dofile(LockOn_Options.common_script_path.."Fonts/symbols_locale.lua")
dofile(LockOn_Options.common_script_path.."Fonts/fonts_cmn.lua")
dofile(LockOn_Options.common_script_path.."tools.lua")

-- Stroke fonts and symbology
dofile(LockOn_Options.script_path.."Displays/Display_StrokeDefs.lua")

dbg_drawStrokesAsWire = false

-------MATERIALS-------
materials = {}   
materials["INDICATION_COMMON_YELLOW"]	= {255, 255, 0, 255}
materials["INDICATION_COMMON_RED"]		= {255, 0, 0, 255}
materials["INDICATION_COMMON_WHITE"]	= {255, 255, 255, 255}
materials["GENERAL_INFO_GOLD"]			= {255, 197, 3, 255}
materials["MASK_MATERIAL"]				= {255, 0, 255, 50}
materials["PURPLE"]						= {255, 0, 255, 255}
materials["BLACK"]						= {0, 0, 0, 255}
materials["SIMPLE_WHITE"]				= {255, 255, 255, 255}
materials["WHITE"]						= {255, 255, 255, 255}
materials["GUNSIGHT_YELLOW"]			= {255, 255, 0, 128}
materials["RADAR_RED_YELLOW"]			= {102, 51, 51, 255}
materials["RADAR_DARK_RED"]				= {129, 90, 0, 255}

materials["MATTE_WHITE"]				= {67, 71, 71, 255} 
materials["HUD_GREEN_BRIGHT"]			= {0, 255, 0, 255}	
materials["HUD_GREEN_DARK"]				= {0,  20, 0, 255}	
materials["UFC_DARK_RED"]				= {129, 0, 0, 255}

--[[materials["UFC_WHITE"]					= {134, 142, 142, 100}
materials["UFC_WHITE_L1"]				= {120, 123, 131, 120}
materials["UFC_WHITE_L2"]				= {158, 80, 68, 95}
materials["UFC_WHITE_L3"]				= {158, 80, 68, 95}
materials["UFC_WHITE_L4"]				= {157, 68, 68, 105}
materials["UFC_WHITE_L5"]				= {120, 123, 131, 120}
materials["UFC_WHITE_L6"]				= {120, 123, 131, 120}]]

materials["UFC_WHITE"]					= {0, 255, 0, 100}
materials["UFC_WHITE_L1"]				= {0, 255, 0, 100}
materials["UFC_WHITE_L2"]				= {0, 255, 0, 100}
materials["UFC_WHITE_L3"]				= {0, 255, 0, 100}
materials["UFC_WHITE_L4"]				= {0, 255, 0, 100}
materials["UFC_WHITE_L5"]				= {0, 255, 0, 100}
materials["UFC_WHITE_L6"]				= {0, 255, 0, 100}

materials["MFD_GREEN"]					= {0, 255, 0, 255}

materials["MFD_ADI_BLACK"]				= {0, 0, 0, 0}
materials["MFD_ADI_GREEN"]				= {0,  20, 0, 255}
materials["MFD_ADI_BLUE"]				= {0, 0, 128, 255}
materials["MFD_ADI_BROWN"]				= {73, 56, 41, 255}

materials["RADAR_GREEN_FRAME1"]			= {0, 128, 0, 255}	
materials["RADAR_GREEN_FRAME2"]			= {0,  64, 0, 255}	

materials["RADAR_BLUE_FRAME1"]			= {130, 206, 250, 255}	

materials["SUN_VISOR"]					= {0, 0, 0, 150}

-------TEXTURES-------
textures = {}

textures["ARCADE"]				= {"arcade.tga",	materials["INDICATION_COMMON_RED"]}
textures["ARCADE_PUPRLE"]		= {"arcade.tga",	materials["PURPLE"]}
textures["ARCADE_WHITE"]		= {"arcade.tga",	materials["WHITE"]}

textures["HUD_GREEN_stroke_symb"]	= {nil, materials["HUD_GREEN_BRIGHT"]}
textures["HUD_GREEN_solid_lines"]	= {nil, materials["HUD_GREEN_BRIGHT"]}
textures["HUD_GREEN_dashed_lines"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["HUD_GREEN_BRIGHT"]}

textures["HUD_COLOR_stroke_symb"]	= {nil, materials["WHITE"]}
textures["HUD_COLOR_solid_lines"]	= {nil, materials["WHITE"]}
textures["HUD_COLOR_dashed_lines"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}

textures["MFD_radar_video_RBM"]			= {nil, 		materials["WHITE"]}
textures["MFD_radar_video_HRM_PPI"]		= {nil, 		materials["WHITE"]}
textures["MFD_radar_video_HRM_PATCH"]	= {nil, 		materials["WHITE"]}

textures["MFD_TFR_raw_video"]			= {nil, 		materials["WHITE"]}
textures["MFD_TFR_synth_terrain"]		= {nil, 		materials["WHITE"]}


-- HUD
textures["HUD_stroke_symb"]		= {nil, materials["HUD_GREEN_BRIGHT"]}
textures["HUD_solid_lines"]		= {nil, materials["HUD_GREEN_BRIGHT"]}
textures["HUD_dashed_lines"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["HUD_GREEN_BRIGHT"]}


-- HUD REPEATER
textures["HUD_stroke_symb_rep"]		= {nil, materials["WHITE"]}
textures["HUD_solid_lines_rep"]		= {nil, materials["WHITE"]}
textures["HUD_dashed_lines_rep"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["hud_repeater_baked_image"] = {nil, materials["WHITE"]}



-----------------------------------------------
-- FRONT COCKPIT MPD & MPCD
-----------------------------------------------
-- MFDs
textures["mfdg_strk_symb_fg"]	= {nil, materials["MFD_GREEN"]}
textures["mfdg_strk_symb_bg"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top"]	= {nil, materials["MFD_ADI_BLACK"]}
textures["mfdg_strk_adi_btm"]	= {nil, materials["MFD_ADI_GREEN"]}
textures["mfdg_strk_rdr_sym"]	= {nil, materials["MFD_GREEN"]}
textures["mfdg_strk_rdr_fr1"]	= {nil, materials["RADAR_GREEN_FRAME1"]}
textures["mfdg_strk_rdr_fr2"]	= {nil, materials["RADAR_GREEN_FRAME2"]}
textures["mfdg_dashed_lines"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["MFD_GREEN"]}
textures["mfd_baked_image"]		= {nil, materials["MFD_GREEN"]}

-- MPD LEFT
textures["mfdg_strk_symb_fg_2"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_2"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_2"]	= {nil, materials["MFD_ADI_BLACK"]}
textures["mfdg_strk_adi_btm_2"]	= {nil, materials["MFD_ADI_GREEN"]}
textures["mfdg_strk_rdr_sym_2"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_2"]	= {nil, materials["RADAR_GREEN_FRAME1"]}
textures["mfdg_strk_rdr_fr2_2"]	= {nil, materials["RADAR_GREEN_FRAME2"]}
textures["mfdg_dashed_lines_2"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_fcl_baked_image"]	= {nil, materials["MFD_GREEN"]}

-- MPD RIGHT
textures["mfdg_strk_symb_fg_3"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_3"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_3"]	= {nil, materials["MFD_ADI_BLACK"]}
textures["mfdg_strk_adi_btm_3"]	= {nil, materials["MFD_ADI_GREEN"]}
textures["mfdg_strk_rdr_sym_3"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_3"]	= {nil, materials["RADAR_GREEN_FRAME1"]}
textures["mfdg_strk_rdr_fr2_3"]	= {nil, materials["RADAR_GREEN_FRAME2"]}
textures["mfdg_dashed_lines_3"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_fcr_baked_image"]	= {nil, materials["MFD_GREEN"]}

-- MPCD CENTER
textures["mfdg_strk_symb_fg_1"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_1"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_1"]	= {nil, materials["MFD_ADI_BLUE"]}
textures["mfdg_strk_adi_btm_1"]	= {nil, materials["MFD_ADI_BROWN"]}
textures["mfdg_strk_rdr_sym_1"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_1"]	= {nil, materials["RADAR_BLUE_FRAME1"]}
textures["mfdg_strk_rdr_fr2_1"]	= {nil, materials["WHITE"]}
textures["mfdg_dashed_lines_1"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_fcc_baked_image"]	= {nil, materials["WHITE"]}

-----------------------------------------------
-- REAR COCKPIT MPD & MPCD
-----------------------------------------------
-- MPCD LEFT
textures["mfdg_strk_symb_fg_4"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_4"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_4"]	= {nil, materials["MFD_ADI_BLUE"]}
textures["mfdg_strk_adi_btm_4"]	= {nil, materials["MFD_ADI_BROWN"]}
textures["mfdg_strk_rdr_sym_4"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_4"]	= {nil, materials["RADAR_BLUE_FRAME1"]}
textures["mfdg_strk_rdr_fr2_4"]	= {nil, materials["WHITE"]}
textures["mfdg_dashed_lines_4"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_rclo_baked_image"] = {nil, materials["WHITE"]}

-- MPD LEFT
textures["mfdg_strk_symb_fg_5"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_5"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_5"]	= {nil, materials["MFD_ADI_BLACK"]}
textures["mfdg_strk_adi_btm_5"]	= {nil, materials["MFD_ADI_GREEN"]}
textures["mfdg_strk_rdr_sym_5"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_5"]	= {nil, materials["RADAR_GREEN_FRAME1"]}
textures["mfdg_strk_rdr_fr2_5"]	= {nil, materials["RADAR_GREEN_FRAME2"]}
textures["mfdg_dashed_lines_5"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_rcli_baked_image"] = {nil, materials["MFD_GREEN"]}

-- MPD RIGHT
textures["mfdg_strk_symb_fg_6"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_6"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_6"]	= {nil, materials["MFD_ADI_BLACK"]}
textures["mfdg_strk_adi_btm_6"]	= {nil, materials["MFD_ADI_GREEN"]}
textures["mfdg_strk_rdr_sym_6"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_sym_6"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_6"]	= {nil, materials["RADAR_GREEN_FRAME1"]}
textures["mfdg_strk_rdr_fr2_6"]	= {nil, materials["RADAR_GREEN_FRAME2"]}
textures["mfdg_dashed_lines_6"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_rcri_baked_image"] = {nil, materials["MFD_GREEN"]}

-- MPCD RIGHT
textures["mfdg_strk_symb_fg_7"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_symb_bg_7"]	= {nil, materials["BLACK"]}
textures["mfdg_strk_adi_top_7"]	= {nil, materials["MFD_ADI_BLUE"]}
textures["mfdg_strk_adi_btm_7"]	= {nil, materials["MFD_ADI_BROWN"]}
textures["mfdg_strk_rdr_sym_7"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_sym_7"]	= {nil, materials["WHITE"]}
textures["mfdg_strk_rdr_fr1_7"]	= {nil, materials["RADAR_BLUE_FRAME1"]}
textures["mfdg_strk_rdr_fr2_7"]	= {nil, materials["WHITE"]}
textures["mfdg_dashed_lines_7"]	= {LockOn_Options.script_path.."Resources/Indicators/Dashed_Line.dds", 		materials["WHITE"]}
textures["mfd_rcro_baked_image"] = {nil, materials["WHITE"]}


textures["rbm_video_test"]	    = {LockOn_Options.script_path.."Resources/Indicators/rbm_video_test.tga", 	materials["WHITE"]}
textures["lantirn_line_mask"]	= {LockOn_Options.script_path.."Resources/Indicators/scanline_mask.tga", 	{0, 0, 0, 16}}
textures["mfd_line_mask"]	    = {LockOn_Options.script_path.."Resources/Indicators/scanline_mask.tga", 	{0, 0, 0, 96}}
textures["tpod_effect_shade"]	= {nil, 	{0, 0, 0, 96}}

---- Sun Visor ----
textures["helmet_sun_visor"]				= {LockOn_Options.script_path.."Resources/visor.tga", materials["SUN_VISOR"]}

-- Digital Displays


-------FONTS----------
fontdescription = {}
fontdescription["font_general_loc"]	= fontdescription_cmn["font_general_loc"]

LCD_sxsize	= 14
LCD_xsize	= 109
LCD_ysize	= 72.0 * 2	-- 144

fontdescription["font_F15E_LCD"] = {
	texture		= LockOn_Options.script_path.."Resources/Fonts/font_UFC_F15E.dds",
	size		= {7, 7},
	resolution	= {1024, 1024},
	default		= {LCD_xsize, LCD_ysize},
	chars		= {
		 [1]   = {32,  LCD_xsize,  LCD_ysize}, -- [space]
		 [2]   = {42,  LCD_xsize,  LCD_ysize}, -- *
		 [3]   = {43,  LCD_xsize,  LCD_ysize}, -- +
		 [4]   = {45,  LCD_xsize,  LCD_ysize}, -- -
		 [5]   = {46,  LCD_sxsize, LCD_ysize}, -- .
		 [6]   = {47,  LCD_xsize,  LCD_ysize}, -- /
		 [7]   = {48,  LCD_xsize,  LCD_ysize}, -- 0
		 [8]   = {49,  LCD_xsize,  LCD_ysize}, -- 1
		 [9]   = {50,  LCD_xsize,  LCD_ysize}, -- 2
		 [10]  = {51,  LCD_xsize,  LCD_ysize}, -- 3
		 [11]  = {52,  LCD_xsize,  LCD_ysize}, -- 4
		 [12]  = {53,  LCD_xsize,  LCD_ysize}, -- 5
		 [13]  = {54,  LCD_xsize,  LCD_ysize}, -- 6
		 [14]  = {55,  LCD_xsize,  LCD_ysize}, -- 7
		 [15]  = {56,  LCD_xsize,  LCD_ysize}, -- 8
		 [16]  = {57,  LCD_xsize,  LCD_ysize}, -- 9
		 [17]  = {58,  LCD_sxsize, LCD_ysize}, -- :
		 [18]  = {65,  LCD_xsize,  LCD_ysize}, -- A
		 [19]  = {66,  LCD_xsize,  LCD_ysize}, -- B
		 [20]  = {67,  LCD_xsize,  LCD_ysize}, -- C
		 [21]  = {68,  LCD_xsize,  LCD_ysize}, -- D
		 [22]  = {69,  LCD_xsize,  LCD_ysize}, -- E
		 [23]  = {70,  LCD_xsize,  LCD_ysize}, -- F
		 [24]  = {71,  LCD_xsize,  LCD_ysize}, -- G
		 [25]  = {72,  LCD_xsize,  LCD_ysize}, -- H
		 [26]  = {73,  LCD_xsize,  LCD_ysize}, -- I
		 [27]  = {74,  LCD_xsize,  LCD_ysize}, -- J
		 [28]  = {75,  LCD_xsize,  LCD_ysize}, -- K
		 [29]  = {76,  LCD_xsize,  LCD_ysize}, -- L
		 [30]  = {77,  LCD_xsize,  LCD_ysize}, -- M
		 [31]  = {78,  LCD_xsize,  LCD_ysize}, -- N
		 [32]  = {79,  LCD_xsize,  LCD_ysize}, -- O
		 [33]  = {80,  LCD_xsize,  LCD_ysize}, -- P
		 [34]  = {81,  LCD_xsize,  LCD_ysize}, -- Q
		 [35]  = {82,  LCD_xsize,  LCD_ysize}, -- R
		 [36]  = {83,  LCD_xsize,  LCD_ysize}, -- S
		 [37]  = {84,  LCD_xsize,  LCD_ysize}, -- T
		 [38]  = {85,  LCD_xsize,  LCD_ysize}, -- U
		 [39]  = {86,  LCD_xsize,  LCD_ysize}, -- V
		 [40]  = {87,  LCD_xsize,  LCD_ysize}, -- W
		 [41]  = {88,  LCD_xsize,  LCD_ysize}, -- X
		 [42]  = {89,  LCD_xsize,  LCD_ysize}, -- Y
		 [43]  = {90,  LCD_xsize,  LCD_ysize}, -- Z
		 [44]  = {symbol['°'], LCD_sxsize, LCD_ysize}, -- º
		 [45]  = {39,  LCD_xsize,  LCD_ysize}, -- '
		 [46]  = {35,  LCD_xsize,  LCD_ysize}, -- #
		 [47]  = {62,  LCD_xsize,  LCD_ysize}, -- >
		 [48]  = {94,  LCD_xsize,  LCD_ysize}, -- ^
		 [49]  = {37,  LCD_xsize,  LCD_ysize}, -- %
	}
}

-- Stroke Fonts
fontdescription["font_stroke_HUD"] = {
	class     = "ceSLineFont",
	symb_storage = "stroke_font",
	thickness  = stroke_thickness,
	fuzziness  = stroke_fuzziness,
	draw_as_wire = dbg_drawStrokesAsWire,
	default    = {12, 20}, -- DIs (display increments)
	chars	   = {
		 [1]   = {latin['A'], "A"},
		 [2]   = {latin['B'], "B"},
		 [3]   = {latin['C'], "C"},
		 [4]   = {latin['D'], "D"},
		 [5]   = {latin['E'], "E"},
		 [6]   = {latin['F'], "F"},
		 [7]   = {latin['G'], "G"},
		 [8]   = {latin['H'], "H"},
		 [9]   = {latin['I'], "I"},
		 [10]  = {latin['J'], "J"},
		 [11]  = {latin['K'], "K"},
		 [12]  = {latin['L'], "L"},
		 [13]  = {latin['M'], "M"},
		 [14]  = {latin['N'], "N"},
		 [15]  = {latin['O'], "O"},
		 [16]  = {latin['P'], "P"},
		 [17]  = {latin['Q'], "Q"},
		 [18]  = {latin['R'], "R"},
		 [19]  = {latin['S'], "S"},
		 [20]  = {latin['T'], "T"},
		 [21]  = {latin['U'], "U"},
		 [22]  = {latin['V'], "V"},
		 [23]  = {latin['W'], "W"},
		 [24]  = {latin['X'], "X"},
		 [25]  = {latin['Y'], "Y"},
		 [26]  = {latin['Z'], "Z"},
		 
		 [27]  = {symbol['0'], "0"},
		 [28]  = {symbol['1'], "1"},
		 [29]  = {symbol['2'], "2"},
		 [30]  = {symbol['3'], "3"},
		 [31]  = {symbol['4'], "4"},
		 [32]  = {symbol['5'], "5"},
		 [33]  = {symbol['6'], "6"},
		 [34]  = {symbol['7'], "7"},
		 [35]  = {symbol['8'], "8"},
		 [36]  = {symbol['9'], "9"},
		 
		 [37]  = {symbol['-'], "symbol-minus"},
		 [38]  = {symbol['+'], "symbol-plus"},
		 [39]  = {symbol['\''], "symbol-apostrophe"},
		 [40]  = {symbol['('], "symbol-parenthesis-left"},
		 [41]  = {symbol[')'], "symbol-parenthesis-right"},
		 [42]  = {symbol['*'], "symbol-asterisk"},
		 [43]  = {symbol['%'], "symbol-percent"},
		 [44]  = {symbol[','], "symbol-comma"},
		 [45]  = {symbol['°'], "symbol-degree"},
		 [46]  = {symbol['.'], "symbol-period"},
		 [47]  = {symbol['/'], "symbol-slash"},
		 [48]  = {symbol['\\'], "symbol-backslash"},
		 [49]  = {symbol['\"'], "symbol-quote"},
		 [50]  = {symbol['?'], "symbol-question"},
		 [51]  = {symbol[':'], "symbol-colon"},
		 [52]  = {symbol['#'], "symbol-octothorpe"},
		 [53]  = {symbol['='], "symbol-equal"},
		 [54]  = {symbol['_'], "symbol-underscore"},
	}
}


fontdescription["font_stroke_HUD_rep"] = {
	class     = "ceSLineFont",
	symb_storage = "stroke_font",
	thickness  = MFD_stroke_thickness*6,
	fuzziness  = MFD_stroke_fuzziness*6,
	draw_as_wire = dbg_drawStrokesAsWire,
	default    = {12, 20}, -- DIs (display increments)
	chars	   = {}
}

copyTable(fontdescription["font_stroke_HUD_rep"].chars, fontdescription["font_stroke_HUD"].chars)



fontdescription["font_stroke_MFD"] = {
	class     = "ceSLineFont",
	symb_storage = "stroke_font_MFD",
	thickness  = MFD_stroke_thickness,
	fuzziness  = MFD_stroke_fuzziness,
	draw_as_wire = dbg_drawStrokesAsWire,
	default    = {8, 13}, -- DIs (display increments)
	chars	   = {
		 [1]   = {latin['A'], "A"},
		 [2]   = {latin['B'], "B"},
		 [3]   = {latin['C'], "C"},
		 [4]   = {latin['D'], "D"},
		 [5]   = {latin['E'], "E"},
		 [6]   = {latin['F'], "F"},
		 [7]   = {latin['G'], "G"},
		 [8]   = {latin['H'], "H"},
		 [9]   = {latin['I'], "I"},
		 [10]  = {latin['J'], "J"},
		 [11]  = {latin['K'], "K"},
		 [12]  = {latin['L'], "L"},
		 [13]  = {latin['M'], "M"},
		 [14]  = {latin['N'], "N"},
		 [15]  = {latin['O'], "O"},
		 [16]  = {latin['P'], "P"},
		 [17]  = {latin['Q'], "Q"},
		 [18]  = {latin['R'], "R"},
		 [19]  = {latin['S'], "S"},
		 [20]  = {latin['T'], "T"},
		 [21]  = {latin['U'], "U"},
		 [22]  = {latin['V'], "V"},
		 [23]  = {latin['W'], "W"},
		 [24]  = {latin['X'], "X"},
		 [25]  = {latin['Y'], "Y"},
		 [26]  = {latin['Z'], "Z"},
		 
		 [27]  = {symbol['0'], "0"},
		 [28]  = {symbol['1'], "1"},
		 [29]  = {symbol['2'], "2"},
		 [30]  = {symbol['3'], "3"},
		 [31]  = {symbol['4'], "4"},
		 [32]  = {symbol['5'], "5"},
		 [33]  = {symbol['6'], "6"},
		 [34]  = {symbol['7'], "7"},
		 [35]  = {symbol['8'], "8"},
		 [36]  = {symbol['9'], "9"},
		 
		 [37]  = {symbol['-'],  "symbol-minus"},
		 [38]  = {symbol['+'],  "symbol-plus"},
		 [39]  = {symbol['\''], "symbol-apostrophe"},
		 [40]  = {symbol['('],  "symbol-parenthesis-left"},
		 [41]  = {symbol[')'],  "symbol-parenthesis-right"},
		 [42]  = {symbol['*'],  "symbol-asterisk"},
		 [43]  = {symbol['%'],  "symbol-percent"},
		 [44]  = {symbol[','],  "symbol-comma"},
		 [45]  = {symbol['@'],  "symbol-degree"},
		 [46]  = {symbol['.'],  "symbol-period"},
		 [47]  = {symbol['/'],  "symbol-slash"},
		 [48]  = {symbol['\\'], "symbol-backslash"},
		 [49]  = {symbol['\"'], "symbol-quote"},
		 [50]  = {symbol['?'],  "question_mark"},
		 [51]  = {symbol[':'],  "colon_mark"},
		 [52]  = {symbol['#'],  "symbol-octothorpe"},
		 [53]  = {symbol['='],  "symbol-equal"},
		 [54]  = {symbol['_'],  "symbol-underscore"},
		 [55]  = {symbol['{'],  "symbol-delta-up"},
		 [56]  = {symbol['}'],  "symbol-delta-down"},
		 [57]  = {symbol['^'],	"symbol-arrow-up"},
		 [58]  = {symbol['`'],	"symbol-arrow-down"}, 
		 [59]  = {symbol['['],	"symbol-arrow-left"},
		 [60]  = {symbol[']'],	"symbol-arrow-right"}, 
	}
}

fontdescription["font_stroke_MFD_Wide"] = {
	class     		= "ceSLineFont",
	symb_storage 	= "stroke_font_MFD",
	thickness  		= MFD_stroke_thickness * 2.1,
	fuzziness  		= MFD_stroke_fuzziness,
	draw_as_wire 	= dbg_drawStrokesAsWire,
	default    		= {8, 13},
	chars	   		= fontdescription["font_stroke_MFD"].chars
}



fontdescription["font_markers_MFD"] = {
	class     = "ceSLineFont",
	symb_storage = "stroke_symbols_MFDG",
	thickness  = MFD_stroke_thickness,
	fuzziness  = MFD_stroke_fuzziness,
	draw_as_wire = dbg_drawStrokesAsWire,
	default    = {8, 8}, -- DIs (display increments)
	chars	   = {
		 [1]   = {latin['C'], "marker-circle"},
		 [2]   = {latin['S'], "marker-square"},
		 [3]   = {latin['T'], "marker-triangle"},
		 [4]   = {latin['c'], "marker-circle-dashed"},
		 [5]   = {latin['s'], "marker-square-dashed"},
		 [6]   = {latin['t'], "marker-triangle-dashed"},
		 }
}


fontdescription["font_contacts_MFD"] = {
	class     = "ceSLineFont",
	symb_storage = "stroke_symbols_MFDG",
	thickness  = MFD_stroke_thickness,
	fuzziness  = MFD_stroke_fuzziness,
	draw_as_wire = dbg_drawStrokesAsWire,
	default    = {8, 8}, -- DIs (display increments)
	chars	   = {
		 [1]   = {latin['B'], "contact-brick-full"},
		 [2]   = {latin['b'], "contact-brick-hollow"},
		 [3]   = {latin['p'], "contact-penta-hollow"},
		 [4]   = {latin['C'], "contact-circle-full"},
		 [5]   = {latin['c'], "contact-circle-hollow"},
		 [6]   = {latin['D'], "contact-diamond-full"},
		 [7]   = {latin['d'], "contact-diamond-hollow"},
		 [8]   = {latin['a'], "contact-arrow"},
		 [9]   = {symbol['^'],"contact-caret-up"},
		 [10]  = {latin['v'], "contact-caret-down"},
		 [11]  = {symbol['*'],"contact-flake"},
		 [12]  = {symbol['#'],"contact-ao-pdt"},
		 [13]  = {symbol['|'],"contact-ao-sdt"},
		 [14]  = {latin['T'],"contact-tallbox-hollow"},
		 [15]  = {symbol['-'],"contact-stick-short"},
		 [16]  = {symbol['_'],"contact-stick-long"},
		 [17]  = {latin['M'],"contact-aoj"},
		 [18]  = {latin['m'],"contact-mi"},
		 }
}

-- Definitions
fonts = {}

-- GENERAL FONTS
fonts["font_general_keys"]		= {fontdescription["font_general_loc"], 10, {255,75,75,255}}
fonts["font_hints_kneeboard"]	= {fontdescription["font_general_loc"], 10, {100,0,100,255}}
fonts["font_label_kneeboard"]	= {fontdescription["font_general_loc"], 10, {0, 0, 0, 255}}
fonts["font_warn_kneeboard"]	= {fontdescription["font_general_loc"], 10, {200, 30, 15, 255}}

-- UFC
fonts["font_UFC_indicator"]			= {fontdescription["font_F15E_LCD"],			10, materials["UFC_WHITE"]}
fonts["font_UFC_Line1"]			= {fontdescription["font_F15E_LCD"],				10, materials["UFC_WHITE_L1"]}
fonts["font_UFC_Line2"]			= {fontdescription["font_F15E_LCD"],				10, materials["UFC_WHITE_L2"]}
fonts["font_UFC_Line3"]			= {fontdescription["font_F15E_LCD"],				10, materials["UFC_WHITE_L3"]}
fonts["font_UFC_Line4"]			= {fontdescription["font_F15E_LCD"],				10, materials["UFC_WHITE_L4"]}
fonts["font_UFC_Line5"]			= {fontdescription["font_F15E_LCD"],				10, materials["UFC_WHITE_L5"]}
fonts["font_UFC_Line6"]			= {fontdescription["font_F15E_LCD"],				10, materials["UFC_WHITE_L6"]}

-- HUD
fonts["font_HUD_stroke"]			= {fontdescription["font_stroke_HUD"],			10, materials["HUD_GREEN_BRIGHT"]}

-- HUD Repeater video
fonts["font_HUD_stroke_rep"]		= {fontdescription["font_stroke_HUD_rep"],		10, materials["WHITE"]}

-- MFDs
fonts["font_MFD_stroke"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}
fonts["font_markers_MFD"]			= {fontdescription["font_markers_MFD"],			10, materials["WHITE"]}
fonts["font_contacts_MFD"]			= {fontdescription["font_contacts_MFD"],		10, materials["WHITE"]}

--MPCD Front Center
fonts["font_MFD_stroke_1"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_1"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

--MPD Front Left
fonts["font_MFD_stroke_2"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_2"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

--MPD Front Right
fonts["font_MFD_stroke_3"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_3"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

--MPCD Rear Left
fonts["font_MFD_stroke_4"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_4"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

--MPD Rear Left
fonts["font_MFD_stroke_5"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_5"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

--MPD Rear Right
fonts["font_MFD_stroke_6"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_6"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

--MPCD Rear Right
fonts["font_MFD_stroke_7"]			= {fontdescription["font_stroke_MFD"],			10, materials["WHITE"]}
fonts["font_MFD_stroke_Wide_7"]		= {fontdescription["font_stroke_MFD_Wide"],		10, materials["BLACK"]}

-- path for stroke symbology
symbologyPaths = {	LockOn_Options.script_path.."Resources/Fonts",
					LockOn_Options.script_path.."Resources/Indicators"}
					